/*
		Ce script permet la gestion des differents cookies presents sur le site ReliefWeb. Le but est arriver  enregistrer toutes 
		les informations concernante la sauvgarde des documents choisit par un web-user.
		Quand un document a t choisit une animation est execut.  
		 
		D. Cereghetti & G. Mengisen, CORIS SA, 31 Mai , 2004, pour OCHA
		 
		D. Cereghetti & G. Mengisen, 31 Mai, 2004
		- Fonction pour la sauvgarde des cookie		
		- Fonction pour retourner des valeurs du cookie
		- Fonction pour l'animation(detection position de l'image et du DIV correspondante)
		- Fonctions pour l'enregistrement des differents cookies concernantes "Update", "Vacancies", "Training", "Policy" et "Link"
		 
		Sommaire des procedure:
		- Les documents qui sont dans le cookie sont cachs 
		- Un document est choisit (evenement onClick sur l'image). Un control sur le totale des documents est effectu (si dpasse le maximum 50 rien se passe)
		- Est calcul la position initiale de l'image.
		- Est calcul la position de l'image pour l'animation
		- Start de l'animation (qui suit une ligne droite o le point initiale est la position de l'image cliqu et la finale est le link de "ReliefWeb")
		- Ajouter la cl de l'article ou cookie correspondante
		-Gestion de la section critique:
			1) aprs chaque click un delay d'un second est attendu avant d'envoyer le submit
			2) une code d'attente (qui est lanc une fois le submit est effectu) est gr
			3) su refresh de la page ou fermeture si est ncessaire un submit est effectu: IE -->evenement onBeforUnload), NE--> ouverture d'un pop-up     
*/

//set variables
{
timerID = 0;
timerID2 = 0;
var control =0;
var counter = 0;
//if an animation started block a user-web exit
var exit=0;

var mobjIFrameDoc; 		//the document object of the IFrame
var mobjForm;	   		//global form object
var IFrameIsPresent=1; 	//don't change this default value!

//Detection Browser 
var isID =0;
var isAll=0;
var isLayer=0;
var isIE5=0;
}

/*For critical section algorithmus
ETAT_IDLE=0  //idle
ETAT_ATTENTE=1 //a document can add in the next submit
ETAT_WAITSUBMIT=2 //waiting submit
ETAT_SUBMIT=3 //submit is started. Wait the end
*/
	
var STATE_IDLE=0;
var STATE_ATTENTE=1;
var STATE_WAITSUBMIT=2;
var STATE_SUBMIT=3;
var STATE_IFRAMEREADY=4;
state = STATE_ATTENTE;

var MAX_DOC_SAVE=50;


//Detection Browser
if (document.layers){ //Netscape 4.x 
	isLayer=1;
} 
else if (document.all){ // Explorer
	isAll=1; 
  var temp=navigator.appVersion.split("MSIE");
  version=parseFloat(temp[1]);
	if(version<=5.5){isIE5=1}
}
else if (document.getElementById){ //Netscape 6.x
	isID=1;
}


//Find a click div
function findDOM(objectID){
	if(isID==1){
		return (document.getElementById(objectID).style);
	}	
	else{	
		if(isAll==1){
			return (document.all[objectID].style);	
		}
		else{
			return (document.layers[objectID]);
		}
	}
}


//Get x of the animation gif
function getX(xInit){
	var dom2=findDOM("playAnimation");
	dom2.left=xInit;
	return xInit;
}
//Get y of animation gif
function getY(yInit){
	var dom2=findDOM("playAnimation");
	dom2.top=yInit;
	return yInit;
}

var xStart = 0;
var yStart = 0;
//Start of animation
function startAnimation(xInit,yInit){
	xStart=xInit;
	yStart=yInit;
	var dom2=findDOM("playAnimation");
	dom2.left=xInit;
	dom2.top=yInit;
	dom2.visibility='visible';
	//alert(xStart + "," + yStart);
	a = -1;
	window.setTimeout("move("+a+")",5);
 }

/* position of myReliefWeb box */
var xEnd = 570;
var yEnd = 10;

function move(a) {
	var objAnim = document.getElementById("playAnimation");
	objAnim.style.left = 	xEnd + a*(xEnd - xStart);
	objAnim.style.top  = 	yEnd + a*(yEnd - yStart);
	//alert(a + ": " + objAnim.style.left + "," + objAnim.style.top);
	a = a+0.1;
	if (a<0) 
		window.setTimeout("move("+a+")",5);
  	else{ 
  	objAnim.style.visibility = 'hidden';
  	control=0;
  }
}


/*
//Compute trajectory of animation
function move(xAnim,yAnim)
{
	var objAnim = document.getElementById("playAnimation");
	objAnim.style.top = (control)*(10-yAnim)/(650-xAnim)+yAnim;
	objAnim.style.left = xAnim+control;
	control = control+ 10;
	if (control<650) 
		window.setTimeout("move("+xAnim+","+yAnim+")",5);
  	else{ 
  	objAnim.style.visibility = 'hidden';
  	control=0;
  }
}
*/

//Find position X of a choose image
function findPosX(obj)
{
	var curleft = 0;
	if (obj.offsetParent)
	{
		while (obj.offsetParent)
		{
			curleft += obj.offsetLeft;
			obj = obj.offsetParent;
		}
	}
	else if (obj.x)
		curleft += obj.x;
	return curleft;
}

//Find positionY of a choose image
function findPosY(obj)
{
	var curtop = 0;
	if (obj.offsetParent)
	{
		while (obj.offsetParent)
		{
			curtop += obj.offsetTop;
			obj = obj.offsetParent;
		}
	}
	else if (obj.y)
		curtop += obj.y;
	return curtop;
}

//Compute the actual form

function computeForm(){
	var usedForm; 	
	if(document.forms['search']==null){
		usedForm = document.forms[0];
	} 
	else {
		usedForm = document.forms['search'];
	}
	return usedForm;
}


// get the IFrame and the main form
function getIFrame(){
	var objIFrame;
	
	mobjForm =computeForm();
	
	//get IFrame object
	
	//objIFrame = document.getElementById("My_RW_IFrame");
	
	if (document.frames) {
		objIFrame = document.frames['My_RW_IFrame'];  //IE 5.0
		if(objIFrame == null){ // undefined
			IFrameIsPresent=0;
		}
	} 
	else {
		objIFrame = document.getElementsByName("My_RW_IFrame");	//all other browsers
		if(objIFrame.length != 0){
			objIFrame = objIFrame[0];
		}
		else
			IFrameIsPresent=0;	
	};

	if(IFrameIsPresent == 1) {		
		//detection of IFrame document; different for different browsers
		try{
			if(objIFrame.contentDocument) //NS6 and higher
				mobjIFrameDoc = objIFrame.contentDocument;

			else if(objIFrame.contentWindow)  //IE 5.5 and IE6
				mobjIFrameDoc = objIFrame.contentWindow.document;

			else if(objIFrame.document) //IE 5.0
				mobjIFrameDoc = objIFrame.document;
			else
				IFrameIsPresent=0;
			//Changement src IFRAME
			
			
		} catch(error) {
			alert("Error getting IFrame");
		}
	}
}

/* Damiano Cereghetti CORIS 2005
 *
 * Cette section garanti que les liens myReliefWeb sont toujours calcul sur l'onload de la page.
 * Pour l'utilisation mettre la fonction getCookieValue() dans le onLoad() de la page, cette fonction retourne
 * le nombre de cookie et cre le lien en haute de la page.
 * La fonction appelle aussi la fonction changeIframeURL qui permette d'adresser l'IFRAME sur le profile de la personne une 
 * fois qu'il est charge.
 *
 */

function getCookieValue(){
		
	var form=computeForm();
	var HTML="";
	//cookie Values: Update; Vacancies; Training; Policy
	var profileUser=getCookie("ReliefWeb");
	//alert("Profile user: "+profileUser);
	//Procedure si le profile du user est vide

	if(profileUser=="" || profileUser==null){
		//alert(form.txt_010Form.value);
		if(form.txt_010Form.value=="doc900LogIn" || form.txt_010Form.value=="doc900Register" || form.txt_010Form.value=="doc900ForgotPassword" ||  form.txt_010Form.value=="doc900CheckEmail"){
			HTML="<span>log in</span>";
		}
		else{
			HTML="<span><a class=\"noVisited\" href=\"MyRW.nsf/doc900Login?OpenForm&amp;mode=login\">log in</a></span>";
		}
	}
	else{
		//Value totale du cookie
		var profileUserValue=unescape(profileUser);
		//split du cookie
		var valeurUser =profileUserValue.split('~'); 
		//valuer du profile
		form.txt_301ProfileID.value=valeurUser[2];
		//Donne la presence de l'IFRAME
		getIFrame();
		//Changement de l'URL de l'IFRAME si est presente

		if(IFrameIsPresent){
			changeIframeURL(valeurUser[2]);
		}

		//valuer cookie MyReliefWeb
		var updateCookieValue=getCookie("Update");
		var vacanciesCookieValue=getCookie("Vacancies");
		var trainingCookieValue=getCookie("Training");
		var policyCookieValue=getCookie("Policy");

		if(updateCookieValue!=null){form.txt_301StoredUpdateIDs.value=updateCookieValue;}else{form.txt_301StoredUpdateIDs.value=""}
		if(vacanciesCookieValue!=null){form.txt_301StoredVacanciesIDs.value=vacanciesCookieValue;}else{form.txt_301StoredVacanciesIDs.value=""}
		if(trainingCookieValue!=null){form.txt_301StoredTrainingIDs.value=trainingCookieValue;}else{form.txt_301StoredTrainingIDs.value=""}
		if(policyCookieValue!=null){form.txt_301StoredPolicyIDs.value=policyCookieValue;}else{form.txt_301StoredPolicyIDs.value=""}
		
		//Calcule du nombre des documents
		var numberOfDocs=0;
		var countUpdateDocs=0;
		var countVacanciesDocs=0;
		var countTrainingDocs=0;
		var countPolicyDocs=0;
		 
		if(conditionValueCookie(updateCookieValue)){
			countUpdateDocs=updateCookieValue.split('^').length;
		}
		if(conditionValueCookie(vacanciesCookieValue)){
			countVacanciesDocs=vacanciesCookieValue.split('^').length;
		}
		if(conditionValueCookie(trainingCookieValue)){
			countTrainingDocs=trainingCookieValue.split('^').length;
		}
		if(conditionValueCookie(policyCookieValue)){
			countPolicyDocs= policyCookieValue.split('^').length;
		}
		numberOfDocs=countUpdateDocs+countVacanciesDocs+countTrainingDocs+countPolicyDocs;
		

		//Ajouter la value dans le field
		form.dtxt_301DocumentCount.value=numberOfDocs;

		//var pluriel document/documents
		var docs="document";
		if(numberOfDocs>0){
			docs=docs+"s";
		}
		//ajouter le values calculs dans l'entte
		HTML="<span>"+valeurUser[0]+"</span> | ";
		HTML=HTML+"<span><a class=\"noVisited\" href=\"MyRW.nsf/doc301RedirectLogOut?OpenForm&amp;form="+form.txt_010Form.value+"\">log out</a></span>";	
	 	HTML=HTML+" (<img alt=\"\" height=\"12\" src=\"301docs.gif\" width=\"14\" />&nbsp;<span id=\"counter\">"+numberOfDocs+"</span>&nbsp;"+docs+")";
	}

	HTML=HTML+" | <span id =\"rw\"><a class=\"noVisited\" href=\"javascript:void(openReliefWeb())\">My ReliefWeb</a></span>&nbsp;|&nbsp;";

	var displayInForm=document.getElementById("head-right").innerHTML;
	var display=HTML+displayInForm;

	document.getElementById("head-right").innerHTML=display;
}

function changeIframeURL(profileUser){
	/*
	 *Attention pour l'IFRAME il l'URL complte (host, port,...) est ncessaire!
	 *frames['My_RW_IFrame'].location.href --> bien pour nos browser (IE5..->Firefox,NE) 
	 */
	 
	var form=computeForm();
	var hostNameSite=form.HTTP_Host.value;
	var portName=form.Server_Port.value;
	var linkDirectory=form.dtxt_010RelPathW.value;
	var baseLink="http://"+hostNameSite;
	
	if(portName!="80"){
		baseLink=baseLink+":"+portName
	}
	baseLink=baseLink+linkDirectory;
	frames['My_RW_IFrame'].location.href=baseLink+"MyRw.nsf/(db900ProfileMyReliefWeb)/"+profileUser+"?EditDocument&visible=false";
}


function conditionValueCookie(cookieValue){
	//NE, Firefox
	if(isID==1){
		if(cookieValue.length==0) return false;
		else return true;
	}	
	else{	
		if(cookieValue==null || cookieValue=="") return false;
	else return true;
	}
	
}

/*
 * End gestion cache
 */
 
 function keyVerification(databaseType,keyDocument){
 	var urlXMLKey="";
 	var checkDoc=0;
 	switch (databaseType){
 	
		//Latest Update
		case 0: 
			urlXMLKey="RWB.NSF/(db900SID)?Readviewentries&StartKey="+keyDocument+"&Untilkey="+keyDocument+"z";
		break;
		//Vacancies
		case 1:
			urlXMLKey="res.NSF/(db900SID)?Readviewentries&StartKey="+keyDocument+"&Untilkey="+keyDocument+"z";
		break;
		//Training
		case 2:
			urlXMLKey="rwt.NSF/(db900SID)?Readviewentries&StartKey="+keyDocument+"&Untilkey="+keyDocument+"z";
		break;
		//Policy
		case 3:
			urlXMLKey="lib.NSF/(db900SID)?Readviewentries&StartKey="+keyDocument+"&Untilkey="+keyDocument+"z";
		break;
		//lates Updates
		case 4:
			urlXMLKey="RWB.NSF/(db900SID)?Readviewentries&StartKey="+keyDocument+"&Untilkey="+keyDocument+"z";
		break;
		default : alert("Database not found!");
	}
	//alert(urlXMLKey);
 	var totalXML= loadXMLDoc(urlXMLKey);
	var documentXML = totalXML.documentElement;
	if (documentXML == null)return;
	var objViewEntries = documentXML.getElementsByTagName('viewentry');
	if(objViewEntries.length > 0){
		checkDoc=1;
	}
	else{
		checkDoc=0;
	}
	return checkDoc;
 }
 
 function loadXMLDoc(url) {
    // branch for native XMLHttpRequest object
    if (window.XMLHttpRequest) {
    		try{
        	req = new XMLHttpRequest();
        	req.open("GET", url, false);
        	req.send(null);
        }
        catch(e){
        	alert("Error creating XMLHttpRequest(). Contact your administrator please");
        }      
    } 
    // branch for IE/Windows ActiveX version
    else if (window.ActiveXObject) {
        try{
        	req = new ActiveXObject("Msxml2.XMLHTTP");
       		req.open("GET", url, false);
          req.Send();
        }
        catch(e){
        	alert("Error creating ActiveXObject. Contact your administrator please");
        }
    } 
    //alert(req.responseText);
	return req.responseXML;
}
 
 
 

//Start of animation and saving document IDs in the correspondent cookie
function computeImage(obj,keyDocument,value){
	var x=findPosX(obj);
	var y=findPosY(obj);
	var controlVariable=1;
	var thisUrl= window.location.href;

	// instatiate mobjIFrameDoc and mobjFrom
	getIFrame();

	//alert(mobjIFrameDoc);
	if(IFrameIsPresent){
		try{
	  	if(mobjIFrameDoc._doc301.txt_301CookieUpdate == undefined){ // test 	
				controlVariable=0;
			}
		}
		catch(error) {
			//Pour Firefox & Netscape dans le cas o le cookie existe et le profile a t elimin.
			controlVariable=0;
		}

		//Controle du submit
		if(mobjForm.txt_301ProfileID.value==""){
			//alert("You must be logged in to save a document to My ReliefWeb. Please login first.");
			//Open Saving document to my ReliefWeb page
			window.location=mobjForm.dtxt_010RelPathW.value+"myrw.nsf/doc418?OpenForm&link="+thisUrl;		
		}
		else if(mobjForm.dtxt_301DocumentCount.value > MAX_DOC_SAVE){
			alert("You have reached the maximum number of documents in your profile. This document will not be added.");
		}
		else if(controlVariable==0){
			alert("Your 'My ReliefWeb' profile is could not be found due to technical difficulties. Please re-register or contact the ReliefWeb administration.");	
		}
		else{
			//mobjForm.dtxt_301DocumentCount.value=parseInt(mobjForm.dtxt_301DocumentCount.value)+1;
			//document.getElementById("counter").innerHTML=mobjForm.dtxt_301DocumentCount.value;

			controleSubmit(obj,x,y,keyDocument,value);
		}
	}
	 else {
			//alert("You must be logged in to save a document to My ReliefWeb. Please login first.");
			window.location=mobjForm.dtxt_010RelPathW.value+"myrw.nsf/doc418?OpenForm&link="+thisUrl;	
	}
}


/*if the state =3 the submit is in exection:	
	- block another submit()
	- add value in the list for next submit
	
	- keyDocument ~ 1#ACOS-1234
*/
function controleSubmit(obj,x,y,keyDocument,value){

	state=STATE_ATTENTE;
	//obj.parentNode.style.visibility='hidden';
	mobjForm = computeForm();
	document.getElementById("rw").innerHTML="My ReliefWeb";
	exit=1;

	//change value of cookies
	keyDocument = keyDocument.substring(keyDocument.indexOf("#")+1);
	
 /*
	*function pour controler si la "key" est bien present dans le database
	*/
	//if(keyVerification(value,keyDocument)==0){alert("Document not found in the database");return null};	
 /*
  *end function
  */
	//augmentation du counter
	mobjForm.dtxt_301DocumentCount.value=parseInt(mobjForm.dtxt_301DocumentCount.value)+1;
	document.getElementById("counter").innerHTML=mobjForm.dtxt_301DocumentCount.value;
	//alert(keyDocument);
	addValueToField(keyDocument,value); // without # !
	// call fct to hide images
	imageManager();
	//end of state_attente: setting IFRAME fied for submit()
	state=STATE_WAITSUBMIT;	

	if(state!=STATE_SUBMIT && mobjForm.txt_301AvailableIFRAME.value!=1){
		//if timerID!=0 another document is stopped after submit: the new document is add to list and a timer is restart
		if (timerID!=0) window.clearTimeout(timerID);		
			
		switch (value){
		case 0: 
			mobjIFrameDoc._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;
		break;
		case 1:
			mobjIFrameDoc._doc301.txt_301CookieVacancies.value=mobjForm.txt_301StoredVacanciesIDs.value;
		break;
		case 2:
			mobjIFrameDoc._doc301.txt_301CookieTraining.value=mobjForm.txt_301StoredTrainingIDs.value;		
		break;
		case 3:
			mobjIFrameDoc._doc301.txt_301CookiePolicy.value=mobjForm.txt_301StoredPolicyIDs.value;		
		break;
		case 4:
			mobjIFrameDoc._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;		
		break;
		default : alert("Error1");
		}
		
		mobjIFrameDoc._doc301.txt_301NewSubmitID.value=computeForm().txt_301NewSubmit.value;
		
		//After 1 sec, a submit is called
		timerID = setTimeout("settingState();",1000);
	}
	else{
		//a new timeout control every 0,333 sec if the submit is ended 
		if (timerID2==0) timerID2 = window.setTimeout("controlIFRAME()",333);
	}
	//start icon animation
	startAnimation(x,y);		
}

function controlIFRAME(){
	counter++;
	mobjForm = computeForm();
	document.getElementById("rw").innerHTML="My ReliefWeb";
	mobjForm.txt_301ControlState.value=1;

	if (mobjForm.txt_301AvailableIFRAME.value!=1) {
		document.body.style.cursor = 'default';
	  mobjIFrameDoc._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;
		mobjIFrameDoc._doc301.txt_301CookieVacancies.value=mobjForm.txt_301StoredVacanciesIDs.value;
		mobjIFrameDoc._doc301.txt_301CookieTraining.value=mobjForm.txt_301StoredTrainingIDs.value;
		mobjIFrameDoc._doc301.txt_301CookiePolicy.value=mobjForm.txt_301StoredPolicyIDs.value;
		mobjIFrameDoc._doc301.txt_301NewSubmitID.value=mobjForm.txt_301NewSubmit.value;
		timerID = setTimeout("settingState();",1000);
	  	timerID2 = 0;
	} else {
		timerID2 = window.setTimeout("controlIFRAME();",333);
		//document.body.style.cursor = 'wait';
	}
}

function settingState(){
	mobjForm.txt_301AvailableIFRAME.value=1;
	document.body.style.cursor = 'default'; 
	state=STATE_SUBMIT;
	exit=0;
	mobjForm = computeForm();
	mobjIFrameDoc._doc301.submit();
	//parent.document.getElementById('rw').innerHTML="<a class='noVisited' href='javascript:void(openReliefWeb())'>My ReliefWeb</a>";
}

//This function allow to add a document id in the correspondent field (in the sub010Header)
// keyDocument => shortID
// value => document type
function addValueToField(keyDocument,value){
elementStored="";
mobjForm = computeForm();

switch (value){
	case 0: 
		var controlUpdateValue=mobjForm.txt_301StoredUpdateIDs.value;
		if(controlUpdateValue==""){
			elementStored=mobjForm.txt_301StoredUpdateIDs.value=keyDocument;	
		}
		else{
			if(mobjForm.txt_301StoredUpdateIDs.value.indexOf(keyDocument)==-1){
				mobjForm.txt_301StoredUpdateIDs.value=keyDocument +"^"+ mobjForm.txt_301StoredUpdateIDs.value;
				elementStored=mobjForm.txt_301StoredUpdateIDs.value;		
			}
			else{
				elementStored=mobjForm.txt_301StoredUpdateIDs.value;	
			}
		}
		if(mobjForm.txt_301NewSubmit.value==""){
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value;
		}
		else{
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value + ":" + mobjForm.txt_301NewSubmit.value;
		}
	break;
	case 1:
		var controlVacanciesValue=mobjForm.txt_301StoredVacanciesIDs.value;
		if (controlVacanciesValue=="" ){
			elementStored=mobjForm.txt_301StoredVacanciesIDs.value=keyDocument;	
		}
		else{
			if(mobjForm.txt_301StoredVacanciesIDs.value.indexOf(keyDocument)==-1){
				mobjForm.txt_301StoredVacanciesIDs.value=keyDocument +"^"+ mobjForm.txt_301StoredVacanciesIDs.value;
				elementStored=mobjForm.txt_301StoredVacanciesIDs.value;	
			}
			else{
				elementStored=mobjForm.txt_301StoredVacanciesIDs.value;		
			}
		}
		if(mobjForm.txt_301NewSubmit.value==""){
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value;
		}
		else{
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value + ":" + mobjForm.txt_301NewSubmit.value;
		}		
	break;
	case 2:
		var controlTrainingValues=mobjForm.txt_301StoredTrainingIDs.value;
		if (controlTrainingValues=="" ){
			elementStored=mobjForm.txt_301StoredTrainingIDs.value=keyDocument;	
		}
		else{
			if(mobjForm.txt_301StoredTrainingIDs.value.indexOf(keyDocument)==-1){
				mobjForm.txt_301StoredTrainingIDs.value=keyDocument +"^"+ mobjForm.txt_301StoredTrainingIDs.value;
				elementStored=mobjForm.txt_301StoredTrainingIDs.value;		
			}
			else{
				elementStored=mobjForm.txt_301StoredTrainingIDs.value;	
			}
		}
		if(mobjForm.txt_301NewSubmit.value==""){
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value;
		}
		else{
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value + ":" + mobjForm.txt_301NewSubmit.value;
		}	
	break;
	case 3:
		var controlPolicyValue=mobjForm.txt_301StoredPolicyIDs.value;
		if (controlPolicyValue=="" ){
			elementStored=mobjForm.txt_301StoredPolicyIDs.value=keyDocument;	
		}
		else{
			if(mobjForm.txt_301StoredPolicyIDs.value.indexOf(keyDocument)==-1){
				mobjForm.txt_301StoredPolicyIDs.value=keyDocument +"^"+ mobjForm.txt_301StoredPolicyIDs.value;
				elementStored=mobjForm.txt_301StoredPolicyIDs.value;		
			}
			else{
				elementStored=mobjForm.txt_301StoredPolicyIDs.value;	
			}
		}
		if(mobjForm.txt_301NewSubmit.value==""){
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value;
		}
		else{
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value + ":" + mobjForm.txt_301NewSubmit.value;
		}		
	break;
	case 4: 
		var controlUpdateValues=mobjForm.txt_301StoredUpdateIDs.value;
		if (controlUpdateValues=="" ){
			elementStored=mobjForm.txt_301StoredUpdateIDs.value=keyDocument;			
		}
		else{
			if(mobjForm.txt_301StoredUpdateIDs.value.indexOf(keyDocument)==-1){
				mobjForm.txt_301StoredUpdateIDs.value=keyDocument +"^"+ mobjForm.txt_301StoredUpdateIDs.value;
				elementStored=mobjForm.txt_301StoredUpdateIDs.value;		
			}
			else{
				elementStored=mobjForm.txt_301StoredUpdateIDs.value;	
			}
		}
		if(mobjForm.txt_301NewSubmit.value==""){
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value;
		}
		else{
			mobjForm.txt_301NewSubmit.value=keyDocument+";"+value + ":" + mobjForm.txt_301NewSubmit.value;
		}		
	break;
	default : alert("Error2");
}
	computeCookie(elementStored,value);
}


/*This function add a Maps parameters in the IFRAME*/

function addValue(str_value){
	var controlVariable=1;
	var objIFrame;
	//get IFrame object
	getIFrame();
	
	if(IFrameIsPresent){
		if (mobjForm.txt_301ProfileID.value!="" && mobjForm.dtxt_301DocumentCount.value<50){
			mobjIFrameDoc._doc301.txt_301MapsUpdate.value=str_value;		
		}
	}
}

//This fonction allow to  control a exit window or a refresh for IE. If a submit is executing a alert message is displayed and a new submit is started
function controlSubmitIE(){
	mobjForm =  computeForm();
	
	//if(mobjForm.txt_301ProfileID.value!="" && mobjForm.txt_301AvailableIFRAME.value){
	if(mobjForm.txt_301ProfileID.value!="" && mobjForm.txt_301AvailableIFRAME.value!=undefined ){
		if(exit==1){
				//alert("Your profile being saved, please wait...");
				window.clearTimeout(timerID);
				window.clearTimeout(timerID2);
				mobjIFrameDoc._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;
				mobjIFrameDoc._doc301.txt_301CookieVacancies.value=mobjForm.txt_301StoredVacanciesIDs.value;
				mobjIFrameDoc._doc301.txt_301CookieTraining.value=mobjForm.txt_301StoredTrainingIDs.value;
				mobjIFrameDoc._doc301.txt_301CookiePolicy.value=mobjForm.txt_301StoredPolicyIDs.value;
				mobjIFrameDoc._doc301.txt_301NewSubmitID.value=mobjForm.txt_301NewSubmit.value;
				mobjIFrameDoc._doc301.submit();

		}
		else{
			if(counter=="0"  && mobjForm.txt_301AvailableIFRAME.value!="1" || mobjForm.txt_301ControlState.value=="0" && mobjForm.txt_301AvailableIFRAME.value!="1"){
				return true;
			}
			else{
				//alert("Your profile being saved, please wait...");
				window.clearTimeout(timerID);
				window.clearTimeout(timerID2);
				mobjIFrameDoc._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;
				mobjIFrameDoc._doc301.txt_301CookieVacancies.value=mobjForm.txt_301StoredVacanciesIDs.value;
				mobjIFrameDoc._doc301.txt_301CookieTraining.value=mobjForm.txt_301StoredTrainingIDs.value;
				mobjIFrameDoc._doc301.txt_301CookiePolicy.value=mobjForm.txt_301StoredPolicyIDs.value;
				mobjIFrameDoc._doc301.txt_301NewSubmitID.value=mobjForm.txt_301NewSubmit.value;
				mobjIFrameDoc._doc301.submit();
				//
			}
		}
	}
}

//This fonction allow to  control a exit window or a refresh for NE. If a submit is executing a new windows is open to allow a submit
function controlSubmitNE(){
	mobjForm =  computeForm();

	//if(mobjForm.txt_301ProfileID.value!="" && mobjForm.txt_301AvailableIFRAME.value){
	if(mobjForm.txt_301ProfileID.value!="" && mobjForm.txt_301AvailableIFRAME.value!=undefined ){
		if(counter=="0" && mobjForm.txt_301AvailableIFRAME.value!="1" || mobjForm.txt_301ControlState.value=="0" && mobjForm.txt_301AvailableIFRAME.value!="1"){
			return true;
		}
		else{
			if(isID==1){
					//control if a is not null
					var host=mobjForm.HTTP_Host.value;
					var port =mobjForm.Server_Port.value;
					var path=mobjForm.dtxt_010RelPathW.value;
	
					var base="";
					if(port != 80){
						base="http://"+host+":"+port+path;
					}
					else{
						base="http://"+host+path;
					}
				var message=window.open("http://"+base+"MyRW.nsf/doc301savingProfileNetscape?OpenForm",'window_robot','toolbar=0,location=no,status=no,menubar=no,scrollbars=no,resizable=no,left=200, top=100,width=400, height=400');
			}
		}
	}		
}


//old function 'showImage0  has been removed on Jan 13, 2005 - you can find it in SourceSafe again.

//Save document in the toolbar

//number of form
var type="";

function saveDocument(){
	var typeCookie="";
	var countSavedCookie=0;
	var controlVariable=1;
	
	var thisUrl= window.location.href;
	
	// instatiate mobjIFrameDoc and mobjFrom
	getIFrame();
	
	if(IFrameIsPresent)
		if(!mobjIFrameDoc._doc301.txt_301CookieUpdate)
				controlVariable=0;
		
	if(mobjForm.txt_301ProfileID.value==""){
		//alert("You must be logged in to save a document to My ReliefWeb. Please login first.");
		window.location=mobjForm.dtxt_010RelPathW.value+"myrw.nsf/doc418?OpenForm&link="+thisUrl;		
	}
	
	else if(mobjForm.dtxt_301DocumentCount.value>50){
		alert("You have reached the maximum number of documents in your profile. This document will not be added.");
	}
	else if(controlVariable==0){
		alert("Your 'My ReliefWeb' profile could not be found due to technical difficulties. Please re-register or contact the ReliefWeb administration.");	
	}
	else{
		elementStored="";
		type=mobjForm.txt_900ID.value;
		keyDocument=mobjForm.txt_015DocumentID.value;
		exit=1;


		switch (type){
				//Update cookie
				case "107": 
				//test if value is in the correspondent field
				if(mobjForm.txt_301StoredUpdateIDs.value.indexOf(keyDocument)==-1){
					countSavedCookie++;
					if(mobjForm.txt_301StoredUpdateIDs.value=="" | mobjForm.txt_301StoredUpdateIDs.value==null){
						elementStored=keyDocument;
						mobjIFrameDoc._doc301.txt_301CookieUpdate.value=elementStored;
					}
					else{
						mobjForm.txt_301StoredUpdateIDs.value=keyDocument+"^"+mobjForm.txt_301StoredUpdateIDs.value;
						elementStored=mobjForm.txt_301StoredUpdateIDs.value;	
						mobjIFrameDoc._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;	
					}
					//Change cookie
					computeCookie(elementStored,0);			
					//add value to iframe
					//document.getElementById("myReliefWebValue").contentWindow.document._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;					
					//Set type Cookie
					typeCookie=0;
				}
			break;
			//vacancies cookie
			case "216":
				//test if value is in the correspondent field
				if(mobjForm.txt_301StoredVacanciesIDs.value.indexOf(keyDocument)==-1){
					countSavedCookie++;
					if(mobjForm.txt_301StoredVacanciesIDs.value=="" | mobjForm.txt_301StoredVacanciesIDs.value==null){
						elementStored=keyDocument;
						mobjIFrameDoc._doc301.txt_301CookieVacancies.value=elementStored;
					}
					else{
						mobjForm.txt_301StoredVacanciesIDs.value=keyDocument+"^"+mobjForm.txt_301StoredVacanciesIDs.value;
						elementStored=mobjForm.txt_301StoredVacanciesIDs.value;
						mobjIFrameDoc._doc301.txt_301CookieVacancies.value=mobjForm.txt_301StoredVacanciesIDs.value;		
					}
					//Change cookie
					computeCookie(elementStored,1);			
					//add value to iframe
					//document.getElementById("myReliefWebValue").contentWindow.document._doc301.txt_301CookieVacancies.value=mobjForm.txt_301StoredVacanciesIDs.value;
					//Set type Cookie
					typeCookie=1;
				}
			break;
			//training  cookie
			case "213":
				//test if value is in the correspondent field

				if(mobjForm.txt_301StoredTrainingIDs.value.indexOf(keyDocument)==-1){
					countSavedCookie++;
					if(mobjForm.txt_301StoredTrainingIDs.value=="" | mobjForm.txt_301StoredTrainingIDs.value==null){
						elementStored=keyDocument;
						mobjIFrameDoc._doc301.txt_301CookieTraining.value=elementStored;
					}
					else{
						mobjForm.txt_301StoredTrainingIDs.value=keyDocument+"^"+mobjForm.txt_301StoredTrainingIDs.value;
						mobjIFrameDoc._doc301.txt_301CookieTraining.value=mobjForm.txt_301StoredTrainingIDs.value;
						elementStored=mobjForm.txt_301StoredTrainingIDs.value;		
					}
					//Change cookie
					computeCookie(elementStored,2);			
					//add value to ifram
					//document.getElementById("myReliefWebValue").contentWindow.document._doc301.txt_301CookieTraining.value=mobjForm.txt_301StoredTrainingIDs.value;
					//Set type Cookie
					typeCookie=2;
				}
			break;
			//policy cookie
			case "204":
				if(mobjForm.txt_301StoredPolicyIDs.value.indexOf(keyDocument)==-1){
					countSavedCookie++;
					if(mobjForm.txt_301StoredPolicyIDs.value=="" | mobjForm.txt_301StoredPolicyIDs.value==null){
						elementStored=keyDocument;
						mobjIFrameDoc._doc301.txt_301CookiePolicy.value=elementStored;
					}
					else{
						mobjForm.txt_301StoredPolicyIDs.value=keyDocument+"^"+mobjForm.txt_301StoredPolicyIDs.value;
						elementStored=mobjForm.txt_301StoredPolicyIDs.value;
						mobjIFrameDoc._doc301.txt_301CookiePolicy.value=mobjForm.txt_301StoredPolicyIDs.value;		
					}
					//Change cookie
					computeCookie(elementStored,3);			
					//add value to iframe
					mobjIFrameDoc._doc301.txt_301CookiePolicy.value=mobjForm.txt_301StoredPolicyIDs.value;
					//Set type Cookie
					typeCookie=3;
				}
			break;
				//Maps cookie (Last Updates)
				case "112": 
				//test if value is in the correspondent field
				if(mobjForm.txt_301StoredUpdateIDs.value.indexOf(keyDocument)==-1){
					countSavedCookie++;
					if(mobjForm.txt_301StoredUpdateIDs.value=="" | mobjForm.txt_301StoredUpdateIDs.value==null){
						elementStored=keyDocument;
						mobjIFrameDoc._doc301.txt_301CookieUpdate.value=elementStored;
					}
					else{
						mobjForm.txt_301StoredUpdateIDs.value=keyDocument+"^"+mobjForm.txt_301StoredUpdateIDs.value;
						elementStored=mobjForm.txt_301StoredUpdateIDs.value;
						mobjIFrameDoc._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;		
					}
					//Change cookie
					computeCookie(elementStored,0);			
					//add value to iframe
					//document.getElementById("myReliefWebValue").contentWindow.document._doc301.txt_301CookieUpdate.value=mobjForm.txt_301StoredUpdateIDs.value;
					var num_begin=String(window.location).indexOf('&'); 
					var num_End=String(window.location).length; 
					str_value=String(window.location).substring(num_begin,num_End);
					//document.getElementById("myReliefWebValue").contentWindow.document._doc301.txt_301MapsUpdate.value=str_value;					
					//Set type Cookie
					typeCookie=4;
				}
			break;			
			default : alert("Error: form not found");
		}
		if(countSavedCookie>0){
			//add 1 to counter
			mobjForm.dtxt_301DocumentCount.value=parseInt(mobjForm.dtxt_301DocumentCount.value)+1;
			document.getElementById("counter").innerHTML=mobjForm.dtxt_301DocumentCount.value;
			
			if(mobjForm.txt_301NewSubmit.value==""){
				mobjForm.txt_301NewSubmit.value=keyDocument+";"+typeCookie;
			}
			else{
				mobjForm.txt_301NewSubmit.value=keyDocument+";"+typeCookie + ":" + mobjForm.txt_301NewSubmit.value;
			}		
		
			mobjIFrameDoc._doc301.txt_301NewSubmitID.value=mobjForm.txt_301NewSubmit.value;
				
			if(state!=STATE_SUBMIT && mobjForm.txt_301AvailableIFRAME.value!=1){
				//After 1 sec, a submit is called
				timerID = setTimeout("settingState();",1000);
			}
			else{
				//a new timeout control every 0,333 sec if the submit is ended 
				if (timerID2==0) timerID2 = window.setTimeout("controlIFRAME()",333);
			}
			alert("The document has been saved.");
		}
		else{
			alert("The document has already been saved.");
		}			
	}		
}



/**COOKIE SECTION		
	Allow to create, manage and destroy cookie.
**/
function computeCookie(elementStored,value){
	switch (value){
		case 0: 
			setCookie("Update", elementStored); 
		break;
		case 1:
			setCookie("Vacancies", elementStored); 
		break;
		case 2:
			setCookie("Training", elementStored);
		break;
		case 3:
			setCookie("Policy", elementStored);
		break;
		case 4:
			setCookie("Update", elementStored);
		break;
		default :
			 alert("Error saving cookies");
	}
}

//Function set cookie with dateExpiration = Today + 12 month  
function setCookie(nameOfCookie, valueCookie) {
	//Date expiration cookies
	valueCookie= escape(valueCookie);
	var dateExpiration = new Date();
	var path= " ;path=/"
	dateExpiration.setMonth(dateExpiration.getMonth()+12);
	//set value into cookie
	document.cookie=nameOfCookie+"="+valueCookie+path+"; expires="+dateExpiration.toGMTString()+";";	
}

//Get a value of cookie
function getCookie(nameOfCookie){
	//stored a value of cookie
	var valueCookie=document.cookie;
	//if a cookie exist length>0
	if (valueCookie.length > 0) {              
    		//value index of cookie where "="   
		var beginCookie =  valueCookie.indexOf(nameOfCookie+"=");       
    		//if exist
		if (beginCookie!= -1) {           
			//index after "="
			beginCookie= valueCookie.indexOf("=",beginCookie)+1;
			//end of cookie
			var endCookie =  valueCookie.indexOf(";", beginCookie);
      		if (endCookie == -1){ 
				endCookie =  valueCookie.length;
			}
        		return unescape( valueCookie.substring(beginCookie, endCookie));
    		} 
     }
  return null;
}

function removeKeyFromCookie(cookieName, key) {
	var myCookie = getCookie(cookieName);
	if(myCookie.indexOf(key)!=-1){
		//alert("trying to remove " + key);
		var begin = myCookie.indexOf(key);
		var end = begin + key.length + 1;
		var newCookie= myCookie.substring(0,begin) + myCookie.substring(end,myCookie.length);
		if(newCookie.lastIndexOf("^")==newCookie.length-1){
			newCookie=newCookie.substring(0,newCookie.lastIndexOf("^"));
		}
		setCookie(cookieName,newCookie);	
	}
}

//Open Relief Web links
function openReliefWeb(){
	mobjForm =  computeForm();
	var str=mobjForm.dtxt_010RelPathW.value;
	var thisUrl= window.location.href;
	//var controlVariable=1;
	
	// instatiate mobjIFrameDoc and mobjFrom
	//getIFrame();
	//if(IFrameIsPresent)
	//	if(mobjIFrameDoc._doc301.txt_301CookieUpdate == undefined)
	//		controlVariable=0;
	
	//if(controlVariable!=0){
		url=str+"MyRW.nsf/(db900ProfileMyReliefWeb)/"+mobjForm.txt_301ProfileID.value+"?EditDocument&visible=true";
		if(mobjForm.txt_301ProfileID.value==""){
			//alert("You must be logged in to access your 'My ReliefWeb' profile. Please login first.");	
			window.location=mobjForm.dtxt_010RelPathW.value+"myrw.nsf/doc420?OpenForm&link="+thisUrl;			
		}
		else{
			setCookie("MyReliefWebLink", document.location); 
			window.location.href=url;
		}
	//}
	//else{
	//	alert("Your 'My ReliefWeb' profile is could not be found due to technical difficulties. Please re-register or contact the //ReliefWeb administration.");	
	//}
	
}


/*		 
		D. Cereghetti & G. Mengisen, CORIS SA, 20 aot , 2004 - 2005, pour OCHA / ReliefWeb
		 
		 Les prochaines trois fonctions permettent de changer dynamiquement le <a href> de chaque lief "Open Form"
		 si il y a eu une choix gographique.
		 
		 1) changeURLLinkTags(): a utiliser dans le onload() de la page permette d'obtenir tous les liens
		 2) getNewURL: return le nouveau lien Javascript
		 3) splitURL: return les parameters presents dans le Current URL
*/

function changeURLLinkTags(){
	//innerHTML
	changeLinkKey();

	var currentURL=document.URL;

	//Cas pour le filtre all Maps!
	if(currentURL.indexOf("cc=all")!=-1){
		currentURL=currentURL.substring(0,currentURL.indexOf("&cc=all"))
	}
	lnks=document.getElementsByTagName('a');
	for(i=0;i<lnks.length;i++){
		if(lnks[i].href.toLowerCase().indexOf("?opendocument")!=-1){
			lnks[i].href=getNewURL(currentURL,lnks[i].href);
		}
	}
	for(i=0;i<lnks.length;i++){
		if(lnks[i].href.toLowerCase().indexOf("doc108?openform")!=-1){
			lnks[i].href=getNewURL(currentURL,lnks[i].href);
		}
		if(lnks[i].href.toLowerCase().indexOf("doc209?openDocument")!=-1){
			lnks[i].href=getNewURL(currentURL,lnks[i].href);
		}
	}
	
}

function getNewURL(currentURL,currentLink){

	var newParameters=""; 
	
	//Contains current link 
	var containsLinkURLReg= currentLink.indexOf("&rc=")!=-1 ;
	var containsLinkURLCc= currentLink.indexOf("&cc=")!=-1 ;
	var containsLinkURLEmid= currentLink.indexOf("&emid=")!=-1 ;
	//Parameters important for the left navigator
	var containsCurrentURLReg= currentURL.indexOf("&rc=")!=-1 ;
	var containsCurrentURLCc= currentURL.indexOf("&cc=")!=-1 ;
	var containsCurrentURLEmid= currentURL.indexOf("&emid=")!=-1 ;

	if(!containsLinkURLReg || !containsLinkURLCc || !containsLinkURLEmid){

		if(containsCurrentURLReg  & !containsLinkURLReg){
			//Add reg value to current URL
			newParameters=newParameters+"&rc="+splitURL(currentURL,"rc");						
		}
		if(containsCurrentURLCc & !containsLinkURLCc){
			//Add cc value to current U
			newParameters=newParameters+"&cc="+splitURL(currentURL,"cc");
		}
		if(containsCurrentURLEmid & !containsLinkURLEmid){
			//Add emid value to current URL
			newParameters=newParameters+"&emid="+splitURL(currentURL,"emid");	
		}	
	}	
	return currentLink+newParameters;
}

function splitURL(url,searchParameter){
	var temp = url.split("&");
	var numberOfElements=temp.length;
	var getParameter="";
	for(i=0;i<numberOfElements;i++){
		if(temp[i].split('=')[0] == searchParameter){
			getParameter=temp[i].substring(temp[i].indexOf("=")+1,temp[i].length);
		}
	}
	return getParameter;
}

function changeLinkKey(){
	var countLastBack;
	var iconsSave;

	for(j=0;j<document.images.length;j++){
		countLastBack=document.images[j].src.indexOf("301save.gif");
		//Valeur field
		//numberCategory=eval('numberCategory_'+j);
		//chercher le parent (div) et changer la key (pour la rendre unique)
		//--> avant div id = DCEI-123545
		//--> aprs div id = 1#DCEI-123545
		if(countLastBack!=-1){
			// modify the div tag
			document.images[j].parentNode.setAttribute("id",j + "#" + document.images[j].parentNode.id);
			var func=String(document.images[j].getAttribute("onclick"));
			numberCategory=parseInt(func.substring(func.lastIndexOf(",")+1,func.lastIndexOf(",")+2));
			//Pour chaque type des document une variable 0..3 est assign.

			switch(numberCategory){
				case 0:
					document.images[j].onclick = function(){ 
						var new_key = this.parentNode.getAttribute("id");
						computeImage(this, new_key,0);	
					};
				break;
				case 1:
					document.images[j].onclick = function(){ 
						var new_key = this.parentNode.getAttribute("id");
						computeImage(this, new_key,1);	
					};
				break;
				case 2:
					document.images[j].onclick = function(){ 
						var new_key = this.parentNode.getAttribute("id");
						computeImage(this, new_key,2);	
					};
				break;				
				case 3:
					document.images[j].onclick = function(){ 
						var new_key = this.parentNode.getAttribute("id");
						computeImage(this, new_key,3);	
					};
				break;	
				default:
					document.images[j].onclick = function(){ 
						var new_key = this.parentNode.getAttribute("id");
						computeImage(this, new_key,0);	
					};						
			}
		}
	}
	// call fct to hide / show images
	imageManager();
}



// manage the hidding of images , now only for 301save.gif images!!!
function imageManager(){

	var objForm = computeForm();
	
	//alert("ID: "+objForm.txt_301ProfileID.value);
	//if (objForm.txt_301ProfileID.value=="")
	//	return;
	//alert(document.images.length);
	for(j=0;j<document.images.length;j++){
		saveImage=document.images[j].src.indexOf("301save.gif");
		if(saveImage!=-1){
			if(objForm.txt_301StoredPolicyIDs.value.indexOf(document.images[j].parentNode.id.substring(document.images[j].parentNode.id.indexOf("#")+1))!=-1){
				document.images[j].style.visibility='hidden';
				continue;
			}
			
			if(objForm.txt_301StoredVacanciesIDs.value.indexOf(document.images[j].parentNode.id.substring(document.images[j].parentNode.id.indexOf("#")+1))!=-1){
				document.images[j].style.visibility='hidden';
				continue;
			}	
			
			if(objForm.txt_301StoredTrainingIDs.value.indexOf(document.images[j].parentNode.id.substring(document.images[j].parentNode.id.indexOf("#")+1))!=-1){
				document.images[j].style.visibility='hidden';
				continue;
			}
			
			if(objForm.txt_301StoredUpdateIDs.value.indexOf(document.images[j].parentNode.id.substring(document.images[j].parentNode.id.indexOf("#")+1))!=-1){
				document.images[j].style.visibility='hidden';
				continue;
			}
			
		}
	}
}

function headerSearch(){
	var f=computeForm();

	var browser;
	var operator;
	var database="";
	var formID=f.dtxt_302SearchFormID.value;
	var searchPath=f.dtxt_302SearchPath.value;
	var searchContext;
	var searchType;
	

	//testBrowser
	if(isAll==1){
		browser=1;
	}	
	else{
		browser=0;
	}
	
	// Option value
	if(f.txt_302SearchScope!=undefined){
		for (var counter = 0; counter < f.txt_302SearchScope.length; counter++){
			if (f.txt_302SearchScope[counter].checked){
				break;
			}
		}
	} else
		{counter=1;}  //default: entire site
	
	if(counter==1) {
		formID="1";  //search entire site -> search Documents 'only'
		searchContext='';
		searchType="3";
	} 
	else {
		searchContext=f.dtxt_302SearchContext.value;
		searchType="2";
	}
		


	//remove characters in the search string
	var searchString=trim(f.txt_302SearchString.value.toLowerCase());
	searchString=replace(searchString, " and ", " ");
	searchString=replace(searchString, " or ", " ");
	searchString=replace(searchString, " , ", ", ");
	searchString=replace(searchString, " | ", " ");
	searchString=replace(searchString, " & ", " ");
	var link=searchPath + "?txt_DES_SearchString=" +escape(searchString) + 
				"&num_DES_FormID=" + formID+
				"&num_DES_Browser="+browser+
				"&num_DES_Operator=1" + 
				"&srchType=" + searchType +	searchContext;				

	window.location=link;

}

/***********************/
/** UTILITY FUNCTIONS **/
/***********************/


/*Replace a token in a string
 	 **    s  string to be processed
  	**    t  token to be found and removed
  	**    u  token to be inserted
  	**  returns new String
*/
function replace(s, t, u) {
	i = s.indexOf(t);
	r = "";
	if (i == -1) return s;
	r += s.substring(0,i) + u;
	if ( i + t.length < s.length)
		r += replace(s.substring(i + t.length, s.length), t, u);
  	return r;
 }

// Removes leading and trailing spaces from the passed string. Also removes
// consecutive spaces and replaces it with one space. If something besides
// a string is passed in (null, custom object, etc.) then return the input.

function trim(inputString) {
   if (typeof inputString != "string") { return inputString; }
   var retValue = inputString;
   var ch = retValue.substring(0, 1);
   while (ch == " ") { // Check for spaces at the beginning of the string
      retValue = retValue.substring(1, retValue.length);
      ch = retValue.substring(0, 1);
   }
   ch = retValue.substring(retValue.length-1, retValue.length);
   while (ch == " ") { // Check for spaces at the end of the string
      retValue = retValue.substring(0, retValue.length-1);
      ch = retValue.substring(retValue.length-1, retValue.length);
   }
   while (retValue.indexOf("  ") != -1) { // Note that there are two spaces in the string - look for multiple spaces within the string
      retValue = retValue.substring(0, retValue.indexOf("  ")) + retValue.substring(retValue.indexOf("  ")+1, retValue.length); // Again, there are two spaces in each of the strings
   }
   return retValue; // Return the trimmed string back to the user
} // Ends the "trim" function




/* set a new parameter in the url or modify the value of an existing one */
function setUrlParameter(url, paramName, paramValue) {
	var found = false;
	var url_parts = url.split("?");
	var new_url = url_parts[0] + "?";
	var newQuery = '';
	var url_args = url_parts[1].split("&");
	for(var i=0; i<url_args.length; i++){
		if (i!=0) new_url = new_url + "&"; // don't use '&', IE bug
		var keyval = url_args[i].split('=');
		if (keyval[0] == paramName){
			new_url = new_url + keyval[0] + '=' + paramValue;
			found = true;
		} else {
			if(keyval[1] != null) {
				new_url = new_url + keyval[0] + '=' + keyval[1];
			} else {
				new_url = new_url + keyval[0];
			}
		}
	}
	if (!found)
		if (i!=0) {
			new_url = new_url + "&" + paramName + '=' + paramValue;
		} else {
			new_url = new_url + paramName + '=' + paramValue;
		}
	return new_url;	
}

function baseQuery() {
	var f = document.forms[0];
	var bq = '';
	if (f.dtxt_010CountryCode.value != '')
		bq = "&cc=" + f.dtxt_010CountryCode.value;
	if (f.dtxt_010EmergencyID.value != '')
		bq = bq + "&emid=" + f.dtxt_010EmergencyID.value;
	return bq;
}

//Cette fonction permet d'viter un submit() quand la touche enter est clique. 
//Dans le cas d'une recherche une redirection sur la servlet est faite
function noEnter(eventClick,parameter){
	var characterCode
	 if(eventClick && eventClick.which){
		 eventClick = eventClick
	 	characterCode = eventClick.which
	 }
	 else{
	 	eventClick = event
	 	characterCode = eventClick.keyCode
	 }	 
	 if(characterCode == 13){
	 	//header
	 	if(parameter==0){
	 		headerSearch();
	 		return false
	 	}
	 	//search form (simple or advanced) & result form
		else if(parameter==1 ||parameter==2 ||parameter==3){
			startServlet();
			return false
	 	}
	 }
	 else{
	 	return true
	 }
}

/*
function goSearch(id,emid,reg,cc,formID){
	var f=document.forms[0];
	var cbox=f.txt_303SearchOption;
	var realPath=f.dtxt_010RelPathW.value;
	if(id==1){	
		var newPath=realPath+"srch.nsf/doc302?OpenForm";
	}
	else{
		var newPath=realPath+"srch.nsf/doc303?OpenForm";
	}	

	var parameters = "";
	
	for (i=0;i<cbox.length;i++){
		if (cbox[i].checked==true){control=i;}
	}

	//Change control typ
	if(control==0){control=1}
	else if(control==1){control=0}
	
	if(emid!="-1"){parameters =parameters+"&amp;emid="+emid}
	if(reg!="-1"){parameters =parameters+"&amp;rc="+reg}
	if(cc!="-1"){parameters =parameters+"&amp;cc="+cc}
	if(formID!="-1"){parameters =parameters+"&amp;formID="+formID}
	if(f.txt_303KeySearch.value!=null || f.txt_303KeySearch.value!=""){parameters =parameters+"&searchParameters="+ f.txt_303KeySearch.value}
	
	loadNewUrl=newPath+parameters+"&control="+control;
	window.location.href=loadNewUrl
}
*/


//This fuction is called in the IFRAME (display the My ReliefWeb link)
function getLinkMyRw(){
	parent.document.getElementById('rw').innerHTML="<a class='noVisited' href='javascript:void(openReliefWeb())'>My ReliefWeb</a>";
}

//old search has been removed on Jan 13, 2005 - you can find it in SourceSafe again.