var numnotifications =0;
var notificationtimer;

function addNotification(txt){
    return _addNotification(txt,5000);
}

function _addNotification(txt,len){
    var box = document.getElementById('NotifyContainer');
    var container= document.getElementById('notificationContainer');

    while(container.firstChild) container.removeChild(container.firstChild);

    if(numnotifications==0){
        box.style.display='block';    
    }
    var sp = document.createElement("span");
    sp.setAttribute("class","NotificationText");
    sp.setAttribute("id","notificationid");
    sp.appendChild(document.createTextNode(txt));
    sp.appendChild(document.createElement("br"));
    sp.appendChild(document.createElement("br"));

    container.appendChild(sp);
    clearTimeout(notificationtimer);
    notificationtimer=setTimeout("clearNotification()",len);
    return true;
}

function clearNotification(){
    var box = document.getElementById('NotifyContainer');
    var container= document.getElementById('notificationContainer');
    box.style.display='none';
    return true;            
}


function addToBookmarks (id,type,name,artist,jointype) {
    var idString = new String(id);
    var ids = idString.split(",");
    var nameString = new String(name);
    var names = nameString.split(",");
    
    switch (jointype) {
        case 1 : 
            var idtype = "bookmark";
            addNotification("Bookmarks Updated");
            break;
        case 2 : 
            var idtype = "collected";
            addNotification("Collection Updated");
            return; // NOTE*** not showing collection container, so returning here. -rj
            break;
    }
    
    //// delete Help div when first entry gets added
    if ( helpNode = document.getElementById(idtype+"Help") ) {
        helpNodeid = idtype+"Help";
        removeNodeById (helpNodeid);
    }
    
    
    for ( i = 0; i < ids.length; i++ ) {
        // get parent node
        var parentNode = document.getElementById(idtype+"Container");
        // create new nodes
        var nodeDiv = document.createElement("div");
        nodeDiv.setAttribute("class", "ProfileItem" );
        nodeDiv.setAttribute("id", idtype+"-"+type+"-"+ids[i] );
        
        var nodeIconDiv = document.createElement("div");
        nodeIconDiv.setAttribute("class", "ProfileIcon" );
        
        var nodeInfoDiv = document.createElement("div");
        nodeInfoDiv.setAttribute("class", "ProfileInfo" );
        
        
        //create new text node to hold info
        if ( artist != '' ) {
            var textContent = document.createTextNode(artist+" - "+names[i]);
        }
        else { 
            var textContent = document.createTextNode(names[i]);
        }
        var nodeA = document.createElement("a");
        
        switch (type) {
            case 6 : 
            var link = "artist.php?id=";
            var icon = "artist";
            break;
            case 8 : 
            var link = "album.php?id=";
            var icon = "album";
            break;
            case 9 : 
            var link = "track.php?id=";
            var icon = "song";
            break;
            case 4 : 
            var icon = "user";
            var link = "user?id=";
        }
        
        nodeA.setAttribute("href", link+ids[i] );
        
        var nodeImg = document.createElement("img");
        nodeImg.setAttribute("src", "http://static.last.fm/images/icons/"+icon+"SG.gif" );
        nodeImg.setAttribute("border", "0");
        nodeImg.setAttribute("alt", "");
        
        //create new text node to hold info
        if ( artist != '' ) {
            var textContent = document.createTextNode(artist+" - "+names[i]+" ");
        }
        else { 
            var textContent = document.createTextNode(names[i]+" ");
        }
        
        var nodeDel = document.createElement("a");
        nodeDel.setAttribute("href", "/resourceListActions.php?nodeid="+idtype+"-"+type+"-"+ids[i]+"&mode=delete&childid="+ids[i]+"&childtype="+type+"&jointype="+jointype );
        nodeDel.setAttribute("target", "ActionFrame" );
        var textDel = document.createTextNode("[del]"); 
        
        nodeIconDiv.appendChild(nodeImg);
        nodeA.appendChild(textContent);
        nodeDel.appendChild(textDel);
        
        nodeDiv.appendChild(nodeIconDiv);
        nodeInfoDiv.appendChild(nodeA);
        nodeInfoDiv.appendChild(nodeDel);
        nodeDiv.appendChild(nodeInfoDiv);
        parentNode.insertBefore(nodeDiv,parentNode.childNodes[0]);
    }
}

function removeNodeById (nodeid) {
    var childNode = document.getElementById(nodeid);
    if(childNode){
        var parentNode = childNode.parentNode;
        parentNode.removeChild(childNode);
    }
}
