/*
 * =================================================================
 * Gossamer Links - enhanced directory management system
 *
 *   Website  : http://gossamer-threads.com/
 *   Support  : http://gossamer-threads.com/scripts/support/
 *   Revision : $Id: utils.js,v 1.2 2005/03/05 01:29:08 brewt Exp $
 *
 * Copyright (c) 2005 Gossamer Threads Inc.  All Rights Reserved.
 * Redistribution in part or in whole strictly prohibited. Please
 * see LICENSE file for full details.
 * =================================================================
 */

/*
Event Handler
=============
Description:
    A simple cross-browser event handler replacement.
Usage:
    registerEvent(<html_object>, <event>, <handler>);
    unregisterEvent(<html_object>, <event>, <handler>);
Example:
    registerEvent(window, 'onload', myhandler);
Notes:
    html_object is a html object that you wish to register the event on.
    event is a string containing the event you wish to register, eg. 'onload'.
    handler is a function reference for the code you wish to run when the
        event is fired.
*/

function registerEvent(object, event, handler) {
    if (!(object && event && handler))
        return;

    var events = object[event + 'Events'];
    if (!events) {
        object[event + 'Events'] = object[event] ? [object[event], handler] : [handler];
        object[event] = _eventHandler;
    }
    else
        object[event + 'Events'][events.length] = handler;
}

function unregisterEvent(object, event, handler) {
    if (!(object && event && handler))
        return;

    var events = object[event + 'Events'];
    if (!events)
        return;

    for (var i = 0; i < events.length; i++)
        if (object[event + 'Events'][i] == handler)
            return object[event + 'Events'].splice(i, 1);
}

function _eventHandler(event) {
    if (!event) event = window.event;

    var events = this['on' + event.type + 'Events'];
    if (!events)
        return;

    for (var i = 0; i < events.length; i++) {
        this.eventMethod = events[i];
        if (this.eventMethod(event) == false) {
            this.eventMethod = null;
            return false;
        }
        this.eventMethod = null;
    }
}

/*
Check All Checkbox
==================
Description:
    Code to implement a check all checkbox.
Usage:
    checkAllInit(<form_id>, <checkbox_name>, <checkall_id>);
Example:
    registerEvent(window, 'onload', function () { checkAllInit('my_form', 'ID', 'checkall') });
*/

function checkAllInit(form, checkBoxes, checkAllBox) {
    var oForm, oCheckBoxes, oCheckAllBox;
    if (!(form && checkBoxes && checkAllBox &&
        (oForm = document.getElementById(form)) &&
        (oCheckBoxes = oForm.elements[checkBoxes]) &&
        (oCheckAllBox = document.getElementById(checkAllBox))))
        return;

    oCheckAllBox.checkBoxes = oCheckBoxes;
    oCheckAllBox.onclick = _checkAllBoxes;
    registerEvent(oCheckAllBox, 'onclick', _checkAllBoxes);
    for (var i = 0; i < oCheckBoxes.length; i++) {
        oCheckBoxes[i].checkAllBox = oCheckAllBox;
        registerEvent(oCheckBoxes[i], 'onclick', _updateAllBoxes);
    }
}

function _checkAllBoxes() {
    var checkBoxes = this.checkBoxes;
    for (var i = 0; i < checkBoxes.length; i++)
        checkBoxes[i].checked = this.checked;
}

function _updateAllBoxes() {
    var checkBoxes = this.form.elements[this.name];
    var allChecked = true;
    for (var i = 0; i < checkBoxes.length; i++) {
        if (!checkBoxes[i].checked) {
            allChecked = false;
            break;
        }
    }
    this.checkAllBox.checked = allChecked;
}

/*
Hide Objects
============
Description:
    Hide a list of html objects using the display = 'none' style.
Usage:
    hideObjects(<id>[, <id>]*);
Example:
    hideObjects('foo', 'bar', 'baz');
Notes:
    id is the id of the html object you want to hide.
*/

function hideObjects() {
    var args = hideObjects.arguments;
    for (var i = 0; i < args.length; i++) {
        var obj = document.getElementById(args[i]);
        if (obj)
            obj.style.display = 'none';
    }
}
