/*
	url letter codes:
	rm_click_url = c
	rm_entity_id = e
	rm_network_id = n
	rm_publisher_code = e
	rm_dummy_mode = d
	rm_site_id = i
	rm_site_code = I
	rm_invalid_media_types = m
	rm_promote_sizes = p
	rm_section_id = s
	rm_section_code = S
	rm_show_detail = v
	rm_publisher_redirect = x
	rm_banned_pop_types = y
	rm_size_id = z
	rm_creative_id = cr
	rm_segment = g
	rm_prepopped_width = w
	rm_prepopped_height = h
	if rm_iframe_tags t = 3
*/

var url_id, context_id;
var rm_host, rm_creative_id, rm_section_id, rm_section_code, rm_site_id, rm_site_code, rm_network_id, rm_publisher_code ;
var rm_entity_id, rm_banned_pop_types, rm_invalid_media_types, rm_pub_redirect, rm_click_url ;
var rm_promote_sizes, rm_promote_sizes_110, rm_promote_sizes_46 ;
var rm_prepopped_width, rm_prepopped_height ;
var rm_debug_tag, rm_dummy_mode, rm_show_detail, rm_image_tags, rm_iframe_tags, rm_iframe_w, rm_iframe_h ;

var RM_COOKIE_NAME = 'ym_pop_freq' ;

// Check that required variables are defined
if (!rm_host) {
	rm_host = "http://ad.yieldmanager.com" ;
}

if (!window.rm_invalid_media_types) {
	var rm_invalid_media_types = 0 ;
}

//document.write('<SCRIPT SRC="' + rm_host + '/url.js?url=' + rmUrlEncode(document.URL) + '"><\/SCRIPT>') ;

// Check for Flash
// Set variable for Flash player version
var flash_version = 0;
if (flashIntalledCookieExists()) {
	// If cookie exists, get the value of the cookie
	flash_version = flashIntalledCookieExists();		
} else {
	// Check for flash player
	var flash = new Object();
	flash = flashDetection();
	if (flash.installed == true) {
		writeFlashInstalledCookie(flash.version);
		flash_version = flash.version;
	} else {
		// If no flash player, write cookie with value == 0
		writeFlashInstalledCookie(0);
	}
}

function rmShowAd(size) {
	var bad_reason ;
	var original_size = size ;
	
	var rm_ad_size = rmGetSize(size) ;
	if (rm_ad_size < 0) {
		document.write('bad ad tag: invalid size') ;
		return ;
	} else if (!rm_section_id && !rm_section_code && !rm_publisher_code) {
		document.write('bad ad tag: no section_id, section_code, or publisher_code') ;
		return ;
	}

	if (size.indexOf("/") > -1) {
		size = size.split("/")[1];
	} 
	
	var rm_size_arr = size.split("x") ;
	var rm_w = rm_size_arr[0] ;
	var rm_h = rm_size_arr[1] ;
	
	rm_url = rm_host + "/imp?z=" + rm_ad_size ;
	rm_url += rmGetQueryParameters(original_size) ;

	if (rm_iframe_tags) {
		rm_tag_src = '<IFRAME FRAMEBORDER=0 MARGINWIDTH=0 MARGINHEIGHT=0 SCROLLING=NO WIDTH=' + rm_w + ' HEIGHT=' + rm_h + ' SRC="' + rm_url + '"><\/IFRAME>' ;
	} else if (rm_image_tags) {
		rm_image_click_url = rm_host + "/imageclick?z=" + rm_ad_size ;
		rm_image_click_url += rmGetQueryParameters(original_size);
		rm_tag_src = '<A HREF="' + rm_image_click_url + '&rid=[TIMESTAMP]"><IMG WIDTH="' + rm_w + '" HEIGHT="' + rm_h + '" SRC="' + rm_url + '&rid=[TIMESTAMP]" /></A>';
	} else {
		rm_tag_src = '<SCRIPT TYPE="text/javascript" SRC="' + rm_url + '"><\/SCRIPT>' ;
	}

	if (!rm_debug_tag) {
		document.write(rm_tag_src) ;
	} else {
		rm_tag_src = rmReplace(rm_tag_src, '<', '&lt;') ;
		rm_tag_src = rmReplace(rm_tag_src, '>', '&gt;') ;
		document.write('' + rm_tag_src + '') ;
	}
}

function rmShowPop(pop) {
	if (!rm_section_id && !rm_section_code && !rm_publisher_code) {
		document.write('bad ad tag: no section_id, section_code, or publisher_code') ;
		return ; 
	}
	
	//make sure we can show pops
	if(rm_pop_frequency) {
		var pop_id = '' ;
		if (rm_section_id) {
			pop_id = rm_section_id ;
		} else if (rm_section_code) {
			pop_id = rm_section_code ;
		} else if (rm_publisher_code) {
			pop_id = rm_publisher_code ;
		}
	
		if(!rmCanShowPop(pop_id, rm_pop_frequency)) {
			if(rm_debug_tag) document.write('frequency cap exceeded');
			return ;
		} 
	}

	rm_url = rm_host + "/imp?z=0" ;
	rm_url += rmGetQueryParameters() ;
	
	if (rm_banned_pop_types) {
		rm_url += "&y=" + rm_banned_pop_types ;
	}

	if (rm_prepopped_width) {
		rm_url += "&w=" + rm_prepopped_width;
	}

	if (rm_prepopped_height) {
		rm_url += "&h=" + rm_prepopped_height;
	}
	
	if (rm_iframe_tags) {
		rm_tag_src = '<IFRAME FRAMEBORDER=0 MARGINWIDTH=0 MARGINHEIGHT=0 SCROLLING=NO WIDTH=0 HEIGHT=0 SRC="' + rm_url + '"><\/IFRAME>' ;
	} else {
		//rm_tag_src = '<SCRIPT SRC="http://ad.yieldmanager.com/adoutput.js"><\/SCRIPT>' ;
		rm_tag_src = '<SCRIPT TYPE="text/javascript" SRC="' + rm_url + '"><\/SCRIPT>' ;
	}

	if (!rm_debug_tag) {
		document.write(rm_tag_src) ;
	} else {
		rm_tag_src = rmReplace(rm_tag_src, '<', '&lt;') ;
		rm_tag_src = rmReplace(rm_tag_src, '>', '&gt;') ;
		document.write('' + rm_tag_src + '') ;
	}
}

function rmGetQueryParameters(size) {
	var rm_url = '' ;
	
	if (rm_network_id) {
		rm_url += "&n=" + rm_network_id ; 

		if (rm_publisher_code) {
			rm_url += "&E=" + rm_publisher_code ;
		}
		
		if (rm_site_code) {
			rm_url += "&I=" + rm_site_code ;
		}
		
		if (rm_section_code) {
			rm_url += "&S=" + rm_section_code ;
		}
	} else {
		if (rm_entity_id) {
			rm_url += "&e=" + rm_entity_id ;
		}
		
		if (rm_publisher_code) {
			rm_url += "&E=" + rm_publisher_code ;
		}
		
		if (rm_site_id) {
			rm_url += "&i=" + rm_site_id ;
		} else if (rm_site_code) {
			rm_url += "&I=" + rm_site_code ;
		}
	
		if (rm_section_id) {
			rm_url += "&s=" + rm_section_id ;
		} else {
			rm_url += "&S=" + rm_section_code ;
		}
	}
	
	if (rm_iframe_tags) {
		rm_url += "&t=3" ;
	} else if(rm_image_tags) {
		rm_url += "&t=2" ;
	}

	if (rm_promote_sizes) {
		rm_url += "&p=1";
	} else if (rm_promote_sizes_110 && size == "120x600/160x600") {
		rm_url += "&p=1";	
	} else if (rm_promote_sizes_46 && size == "468x60/728x90") {
		rm_url += "&p=1";	
	}
	
	if (rm_invalid_media_types) {
		//if flash_version is set then we know flash media type is not unwanted
		if ((flash_version) && (flash_version == 0)) {
			//add flash to invalid media types (+ 2)
			rm_invalid_media_types = rm_invalid_media_types + 2;
		}
		//otherwise flash is already unwanted so no need to add to m
		rm_url += "&m=" + rm_invalid_media_types ;
	} else if (flash_version == 0) {
		rm_url += "&m=2";
	}
	
	if (rm_dummy_mode) {
		rm_url += "&d=" + rm_dummy_mode ;
	}
	
	if (rm_show_detail) {
		rm_url += "&v=" + rm_show_detail ;
	}
	
	if (rm_pub_redirect) {
		rm_url += "&x=" + rmGetPubRedirect() ;
	}

	if (rm_click_url) {
		rm_url += "&c=" + rmGetClickUrl() ;
	}
	
	return rm_url ; 
}

function rmGetSize(size) {
	if (size.indexOf("pop") > -1) return 0 ;
	else if (size == "120x600") return 1 ;
	else if (size == "300x250") return 2 ;
	else if (size == "336x280") return 3 ;
	else if (size == "468x60") return 4 ;
	else if (size == "550x150") return 5 ;
	else if (size.indexOf("728x90") > -1) return 6 ;
	// size 7 is static textlink
	else if (size == "700x300") return 8 ;
	// size 9 is dynamic textlink
	else if (size.indexOf("160x600") > -1) return 10 ;
	// size 11 is unused
	else if (size == "125x125") return 12 ;
	else if (size == "234x60") return 13 ;
	else if (size == "120x240") return 14 ;
	else if (size == "180x150") return 15 ;
	else if (size == "300x600") return 16 ;
	else if (size == "100x25") return 17 ;
	else if (size == "710x30") return 18 ;
	else if (size == "720x300") return 19 ;
	else if (size == "300x200") return 20 ;
	else if (size == "72x50") return 21 ;
	else return -1 ;
}

function rmGetPubRedirect() {
	var url = rm_pub_redirect ;
	return encodeURIComponent(url) ;
}

function rmGetClickUrl() {
	var url = rm_click_url ;
	return encodeURIComponent(url) ;
}

function rmReplace(myString, toReplace, replaceBy) {
	return (myString.replace(new RegExp(toReplace, 'gi'), replaceBy)) ;
}

function rmTrim(str) { 
	if(str != null) return str.replace(/^\s+/,'').replace(/\s+$/,'') ; 
} 

function rmUrlEncode(txt)
{
	var SAFECHARS = "0123456789" +
		"ABCDEFGHIJKLMNOPQRSTUVWXYZ" +
		"abcdefghijklmnopqrstuvwxyz" +
		"-_.!~*'()" ;
	var HEX = "0123456789ABCDEF" ;

	var plaintext = txt ;
	var encoded = "" ;
	for (var i = 0; i < plaintext.length; i++ ) {
		var ch = plaintext.charAt(i) ;
		if (ch == " ") {
			encoded += "+" ;
		} else if (SAFECHARS.indexOf(ch) != -1) {
			encoded += ch ;
		} else {
			var charCode = ch.charCodeAt(0) ;
			if (charCode > 255) {
				encoded += "+" ;
			} else {
				encoded += "%" ;
				encoded += HEX.charAt((charCode >> 4) & 0xF) ;
				encoded += HEX.charAt(charCode & 0xF) ;
			}
		}
	}
	return encoded ;
};

function rmCanShowPop(section_id, pop_frequency) {
	// Have to look for cookie with this site_id.
	if(rmCookieExists(section_id) == false) {
		// This cookie doesn't exist,
		// so we CAN show the pop.
		ret = true ;

		// We are going to show a pop,
		// so reset cookie.
		rmWritePopFrequencyCookie(section_id, pop_frequency) ;
		
		return true ;
	} else {
		return false ;
	}
}

function rmCookieExists(section_id) {
	var cookieName = RM_COOKIE_NAME + section_id ;

	if(rmGetCookie(cookieName) == null) {
		return false ;
	} else {
		return true ;
	}
}

function rmWritePopFrequencyCookie(section_id, pop_frequency) {
	var cookieName = RM_COOKIE_NAME + section_id ;
	var today = new Date() ;
	var expires = new Date() ;
	expires.setTime(today.getTime() + (1000 * pop_frequency)) ;

	var cookieText = cookieName + "=1;"
		+ "expires=" + expires.toGMTString() + ";" ;
	document.cookie = cookieText ;
	return null ;
}

function flashIntalledCookieExists() {
	var cookieName = "flashInstalled" ;

	if(rmGetCookie(cookieName) == null) {
		return false ;
	} else {
		return rmGetCookie(cookieName) ;
	}
}

function writeFlashInstalledCookie(version) {
	var cookieName = "flashInstalled" ;
	var numdays = 14 ;
	var today = new Date() ;
	var expires = new Date() ;
	expires.setTime(today.getTime() + (1000 * 60 *60*24*numdays)) ;

	var cookieText = cookieName + "=" + version 
		+ "expires=" + expires.toGMTString() + ";" ;
	document.cookie = cookieText ;
	return null ;
}

function flashDetection() {
	var flash=new Object() ;
	flash.installed=false ;
	flash.version='0.0' ;

	if (navigator.plugins && navigator.plugins.length) {
	    for (x=0; x<navigator.plugins.length; x++) {
	        if (navigator.plugins[x].name.indexOf('Shockwave Flash') != -1) {
	            flash.version=navigator.plugins[x].description.split('Shockwave Flash ')[1] ;
	            flash.installed=true ;
	            break ;
	        }
	    }
	} else if (window.ActiveXObject) {
	    for (x=2; x<10; x++) {
	        try {
	            oFlash=eval("new ActiveXObject('ShockwaveFlash.ShockwaveFlash."+x+"');") ;
	            if (oFlash) {
	                flash.installed=true ;
	                flash.version=x+'.0' ;
	            }
	        } catch(e) {}
	    }
	}
	return flash ;
}

// Returns null if cookie doesn't exist.
// Returns cookie value if it exists.
function rmGetCookie(Name) {
	var search = Name + "=" ;
	var CookieString = document.cookie ;
	var result = null ;
	
	if(CookieString.length > 0) {
		offset = CookieString.indexOf(search) ;
		if(offset != -1) {
			offset += search.length ;
			end = CookieString.indexOf(";", offset) ;
			if(end == -1) {
			   end = CookieString.length ;
			}
			result = unescape(CookieString.substring(offset, end)) ;
	   }
	}
	
	return result ;
}
