// Copyright 1999-2001 ValueClick, Inc. All rights reserved.

ValueLoaded = true;
ValueFullVersion = ValueVersion + ".20";

function ValueShowAd() {
  
  ValueOptions = '&v=' + ValueFullVersion;
  ValueFullOptions = '';
  ValueTextTest = 0;
  ValueProtocol = "http://";
  ValueBannerType = self.ValueBannerType || "js";
  ValueNetworkDisableNoCache = 0 || 0; 

  if (self.ValueSecure) ValueProtocol = "https://";
  if (self.ValueCategory) ValueOptions += '&c=' + self.ValueCategory;
  if (self.ValueBorder)   ValueOptions += '&border=1';
  if (self.ValuePlacement) ValueFullOptions += '&p=' + self.ValuePlacement; 
  if (self.ValueKWParam)  ValueOptions += '&r=' + self.ValueKWParam;
  if (self.ValueKeywords) ValueOptions += '&k=' + escape(self.ValueKeywords);
  if (self.ValueKeyCode) ValueOptions += '&' + self.ValueKeyCode;
  if (self.ValueHCat) ValueOptions += '&hcat=' + self.ValueHCat;
  if (self.ValuePBhav) ValueOptions += '&pbhav=' + self.ValuePBhav;
  if (self.ValueTagCascade) ValueOptions += '&tc=' + self.ValueTagCascade;
  if (self.ValueAID) ValueFullOptions += '&aid=' + self.ValueAID;
  if (self.ValuePID) ValueFullOptions += '&pid=' + self.ValuePID;

  if (self.ValueKeyCodes) {
    var tempKC = ValueKeyCodes.join("&"); 
    ValueOptions += '&' + tempKC;
  }

  ValueSizes = '';
  HardSize = 1;

  if (self.ValueWidth) {
    ValueWidth = self.ValueWidth;
  } else {
    ValueWidth = '';
  }

  if (self.ValueHeight) {
    ValueHeight = self.ValueHeight;
  } else {
    ValueHeight = '';
  }

  ValueIFrame = self.ValueIFrame || 0;
  ValueIFrameMSizes = self.ValueIFrameMSizes || 0;

  if (ValueBannerType != 'pop') {

    //non pops should default to type js
    ValueBannerType = 'js';

    //if 'Width' and 'Height' are passed in, use them
    //otherwise, use Width_Height if it exists

    if (ValueWidth && ValueHeight) {
      ValueSizes = '&size=' + ValueWidth + 'x' + ValueHeight;
    } else if (self.ValueWidths_Heights) {
      if (ValueIFrame) {
        //Using IFrame will normally disable using MSizes, but an optional
        //parameter IFrameMSizes allows them both to be used.
        var firstSize = self.ValueWidths_Heights[0];
        if (ValueIFrameMSizes) {
          ValueSizes = '&msizes=' + self.ValueWidths_Heights.join(",");
        } else {
          ValueSizes = '&size=' + firstSize;
        }
        //Set Width & Height for the IFrame
        var firstSizeArray = firstSize.split('x');
        ValueWidth = firstSizeArray[0];
        ValueHeight = firstSizeArray[1];
      } else {
        var ArLen = self.ValueWidths_Heights.length;
        if (ArLen > 1) HardSize = 0;

        ValueSizes = '&msizes=' + ValueWidths_Heights.join(",");
      }
    } else {
      //if no size info is passed in, the size list from host site record or network is used
      //so we can't predict the size
      HardSize = 0;
    }
    
    if (self.ValueBannerSizeOrder) ValueFullOptions += '&bso=' + self.ValueBannerSizeOrder;

    //Do not show text for non-standard banners. ValueNoText must come after this test.
    if (ValueWidth == 468 && ValueHeight == 60) {
      ValueTextTest = 0;
    }else {
      if(! self.ValueNoText) ValueTextTest = 1; 
      self.ValueNoText = true;
    }

    if (! self.ValueNoText) ValueOptions += '&text=1';
    if (self.ValueTargetCurrent) ValueOptions += '&target=self';
  } else {
    ValueSizes = '&size=' + self.ValuePopSize;
  }

  ValueRandom   = Math.round(Math.random()*1000) + 1;
  ValueTempDisableNoCache = 0;

  if (ValueNetworkDisableNoCache) {
    ValueTempDisableNoCache = 1;
  }

  //Publisher setting overrides the network setting
  if (self.ValueCacheBanners && self.ValueCacheBanners == 'yes') {
    ValueTempDisableNoCache = 1;
  } else if (self.ValueCacheBanners && self.ValueCacheBanners == 'no') {
    ValueTempDisableNoCache = 2;
  }

  if (ValueTempDisableNoCache == 1) {
    //don't send no-cache headers 
    ValueRandom = 1;
    ValueOptions += '&disable_no_cache=1';
  } else if (ValueTempDisableNoCache == 2) {
    //send no-cache headers 
    ValueOptions += '&disable_no_cache=0';
  }

  ValueHostInfo = "host=" + ValueHost + "&b=" + ValueID + "." + ValueRandom;

  if (self.ValueServer == null) ValueServer = "ads";

  ValueFullServer   = ValueProtocol + ValueServer + ".hlwd.valueclick.net/";

  ValueBanner   = ValueFullServer + 'cycle?' + ValueHostInfo + ValueOptions + ValueFullOptions + ValueSizes;

  if (ValueBannerType == 'js' && HardSize) ValueDimensions();

  // blank then out so they will only apply for this request. 
  // When there are multiple tags on the same page, we don't want an old
  // tag with these variables to 'infect' a newer tag that doesn't
  // use these variables
  ValueWidth = '';
  ValueHeight = '';

  if (ValueTextTest == 1) self.ValueNoText = false;

  if (navigator.userAgent.indexOf("MSIE") >= 0) {
    // don't try to set the bgcolor etc in the IFRAME for MSIE 3 
    if (navigator.appVersion.indexOf('MSIE 3') < 0) {
      if (self.ValueBgColor)    ValueBanner += '&bgcolor='    + escape(self.ValueBgColor);
      if (self.ValueLinkColor)  ValueBanner += '&linkcolor='  + escape(self.ValueLinkColor);
      if (self.ValueAlinkColor) ValueBanner += '&alinkcolor=' + escape(self.ValueAlinkColor);
      if (self.ValueVlinkColor) ValueBanner += '&vlinkcolor=' + escape(self.ValueVlinkColor);
    }
    if (ValueIFrame == 1 && ValueBannerType == 'js') {
      if (HardSize) {
        document.write('<IFRAME ID="VC" NAME="VC" WIDTH="' + IWidth + '" HEIGHT="' + IHeight + '" ');
      } else {
        document.write('<IFRAME ID="VC" NAME="VC" ');
      }
      document.write('SCROLLING="no" FRAMEBORDER="0" FRAMESPACING="0" MARGINHEIGHT="0" ');
      document.write('MARGINWIDTH="0" BORDER="0" HSPACE="0" VSPACE="0" ');
      document.write('ALIGN="center" SRC="' + ValueBanner + '&t=html">');
      document.write('</IFRAME>');
    } else {
      document.write('<SCRIPT SRC="' + ValueBanner + '&t=' + ValueBannerType + '"');
      document.write(' LANGUAGE="JavaScript"></SCR' + 'IPT>');
    }
  } else {
    // should be all Netscapes that are reading this file 
    if (self.ValueVersion == 1.0 && parseInt(navigator.appVersion) < 5 ) {
      document.write('<table border=0 cellpadding=0 cellspacing=0><tr><td>');
      if (HardSize) {
        document.write('<ILAYER ID="VC" VISIBILITY="hide" BGCOLOR="" WIDTH="' + IWidth);
        document.write('" HEIGHT="' + IHeight + '"></ILAYER>');
      } else {
        document.write('<ILAYER ID="VC" VISIBILITY="hide" BGCOLOR="" ');
        document.write('></ILAYER>');
      }
      document.write('</td></tr></table>');
    } else {
      document.write('<SCRIPT SRC="' + ValueBanner + '&t=' + ValueBannerType + '"');
      document.write(' LANGUAGE="JavaScript"></SCR' + 'IPT>');
    }
  }
}

function ValueDimensions() {
  if (self.ValueNoText) {
    if (self.ValueBorder) {
      IWidth  = ValueWidth + 4;  
      IHeight = ValueHeight + 4;
    } else {
      IWidth  = ValueWidth;  
      IHeight = ValueHeight;
    }       
  } else {
    if (self.ValueBorder) {
      IWidth  = ValueWidth + 4;
      IHeight = ValueHeight + 24;
    } else {
      IWidth  = ValueWidth;
      IHeight = ValueHeight + 24;
    }       
  }
}
