/*
	url letter codes:
	rm_click_url = c
	rm_entity_id = e
	rm_network_id = n
	rm_publisher_code = e
	rm_dummy_mode = d
	rm_site_id = i
	rm_site_code = I
	rm_invalid_media_types = m
	rm_promote_sizes = p
	rm_section_id = s
	rm_section_code = S
	rm_show_detail = v
	rm_publisher_redirect = x
	rm_banned_pop_types = y
	rm_size_id = z
	rm_creative_id = cr
	rm_segment = g

	media types:
	banner/pop = 1
	flash = 2
	text link = 4

	so, m should equal the sum of unwanted types

	pop types:
	1 = popup
	2 = popunder
	4 = layer
	8 = prepopped
	16 = interstitial

	so, y should equal 31 - wanted types
*/

var url_id, context_id;
var rm_creative_id, rm_section_id, rm_section_code, rm_site_id, rm_site_code, rm_network_id, rm_publisher_code ;
var rm_entity_id, rm_banned_pop_types, rm_invalid_media_types, rm_pub_redirect, rm_promote_sizes, rm_click_url ;
var rm_debug_tag, rm_dummy_mode, rm_show_detail;

// Check that required variables are defined
if (!window.rm_host) {
	var rm_host = "ad.yieldmanager.com" ;
}

if (!window.rm_invalid_media_types) {
	var rm_invalid_media_types = 0 ;
}

document.write('<scr'+'ipt src="http://' + rm_host + '/url.js?url=' + url_encode(document.URL) + '"></' + 'scr'+'ipt>') ;

function showAd(size) {
	var bad_reason ;
	var ad_size = getSize(size) ;
	
	if (ad_size < 0) bad_reason = "invalid size" ;
	else if (!rm_section_id && !rm_section_code && !rm_publisher_code) bad_reason = "no section_id or publisher_code" ;
	
	if (bad_reason) {
		document.write('bad ad tag: ' + bad_reason) ;
		return ;
	}

	var qString = "http://" + window.rm_host + "/imp?" ;
	qString += "z=" + ad_size ;

	if (rm_network_id) {
		qString += "&n=" + rm_network_id ; 

		if (rm_publisher_code) {
			qString += "&E=" + rm_publisher_code ;
		}
	} else {
		if (rm_entity_id) {
			qString += "&e=" + rm_entity_id ;
		}
	
		if (rm_site_id) {
			qString += "&i=" + rm_site_id ;
		} else if (rm_site_code) {
			qString += "&I=" + rm_site_code ;
		}
	
		if (rm_section_id) {
			qString += "&s=" + rm_section_id ;
		} else {
			qString += "&S=" + rm_section_code ;
		}
	}

	if (rm_pub_redirect) {
		qString += "&x=" + getPubRedirect() ;
	}

	if (rm_click_url) {
		qString += "&c=" + getClickUrl() ;
	}
	
	if (rm_promote_sizes) {
		qString += "&p=1";
	}

	if (rm_banned_pop_types) {
		qString += "&y=" + rm_banned_pop_types ;
	}

	if (rm_invalid_media_types) {
		qString += "&m=" + rm_invalid_media_types ;
	}

	if (rm_dummy_mode) {
		qString += "&d=" + rm_dummy_mode ;
	}
	
	if (rm_show_detail) {
		qString += "&v=" + rm_show_detail ;
	}
	
	if (rm_debug_tag) {
		document.write('url_id=' + url_id + ' context_id=' + context_id + '<br />') ;
	} else {
		document.write('<SCR'+'IPT TYPE="text/javascript" SRC="') ;
	}
	
	document.write(qString) ;
	
	if (!rm_debug_tag) document.write('"></' + 'SCR'+'IPT>') ;
}


function showPop(pop) {
	//make sure we can show pops
	if(!canShowPop()) {
		return;
	}
	
	//make sure pop_frequency is valid
	if (!window.rm_pop_frequency) {
		rm_pop_frequency = 300 ;
	}
		
	var bad_reason ;
	var ad_size = 0 ;
	
	if (!rm_banned_pop_types) bad_reason = "invalid banned_pop_type" ;
	else if (!rm_section_id && !rm_section_code && !rm_publisher_code) bad_reason = "no section_id or publisher_code" ;
	
	if (bad_reason) {
		document.write('bad ad tag: ' + bad_reason) ;
		return ;
	}

	var qString = "http://" + window.rm_host + "/imp?" ;
	qString += "z=" + ad_size ;

	if (rm_network_id) {
		qString += "&n=" + rm_network_id ; 

		if (rm_publisher_code) {
			qString += "&E=" + rm_publisher_code ;
		}
	} else {
		if (rm_site_id) {
			qString += "&i=" + rm_site_id ;
		} else {
			qString += "&I=" + rm_site_code ;
		}
	
		if (rm_section_id) {
			qString += "&s=" + rm_section_id ;
		} else {
			qString += "&S=" + rm_section_code ;
		}
	}

	if (rm_pub_redirect) {
		qString += "&x=" + getPubRedirect() ;
	}

	if (rm_click_url) {
		qString += "&c=" + getClickUrl() ;
	}
	
	if (rm_promote_sizes) {
		qString += "&p=1";
	}

	if (rm_banned_pop_types) {
		qString += "&y=" + rm_banned_pop_types ;
	}

	if (rm_invalid_media_types) {
		qString += "&m=" + rm_invalid_media_types ;
	}

	if (rm_dummy_mode) {
		qString += "&d=" + rm_dummy_mode ;
	}
	
	if (rm_show_detail) {
		qString += "&v=" + rm_show_detail ;
	}
	
	if (rm_debug_tag) {
		document.write('url_id=' + url_id + ' context_id=' + context_id + '<br />') ;
	} else {
		document.write('<SCR'+'IPT TYPE="text/javascript" SRC="') ;
	}
	
	document.write(qString) ;
	
	if (!rm_debug_tag) document.write('"></' + 'SCR'+'IPT>') ;
}

function showCreative(creativeID) {
	var qString = 'http://' + window.rm_host + '/imp?' ;
	
	if (creativeID) {
		qString += "c=" + creativeID ;
	}
	
	document.write('<SCR'+'IPT TYPE="text/javascript" SRC="') ;
	document.write(qString);
	document.write('"></' + 'SCR'+'IPT>') ;
}

function getInvalidMediaTypes() {
	
}

function getBannedPopTypes() {

}

function getSize(size) {
	if (size.indexOf("pop") > -1 || size.indexOf("layer") > -1 || size.indexOf("interstitial") > -1) {
		return 0 ;
	} else if (size.indexOf("120x600") > -1) {
		return 1 ;
	} else if (size == "300x250") {
		return 2 ;
	} else if (size == "336x280") {
		return 3 ;
	} else if (size.indexOf("468x60") > -1) {
		return 4 ;
	} else if (size == "550x150") {
		return 5 ;
	} else if (size == "728x90") {
		return 6 ;
	// size 7 is static textlink
	} else if (size == "700x300") {
		return 8 ;
	// size 9 is dynamic textlink
	} else if (size == "160x600") {
		return 10 ;
	// size 11 is unused
	} else if (size == "810x650") {
		return 12 ;
	} else if (size == "234x60") {
		return 13 ;
	} else if (size == "120x240") {
		return 14 ;
	} else if (size == "180x150") {
		return 15 ;
	} else if (size == "300x600") {
		return 16 ;
	} else if (size == "800x30") {
		return 17 ;
	} else if (size == "710x30") {
		return 18 ;
	}
	
	return -1 ;
}

function getPubRedirect() {
	var url = rm_pub_redirect ;
	return encodeURIComponent(url) ;
}

function getClickUrl() {
	var url = rm_click_url ;
	return encodeURIComponent(url) ;
}

function replace(myString, toReplace, replaceBy) {
	return (myString.replace(new RegExp(toReplace, 'gi'), replaceBy)) ;
}

function trim(str) { 
	if(str != null) return str.replace(/^\s+/,'').replace(/\s+$/,'') ; 
} 

function url_encode(txt)
{
// The Javascript escape and unescape functions do not correspond
// with what browsers actually do...
	var SAFECHARS = "0123456789" +					// Numeric
		"ABCDEFGHIJKLMNOPQRSTUVWXYZ" +	// Alphabetic
		"abcdefghijklmnopqrstuvwxyz" +
		"-_.!~*'()";					// RFC2396 Mark characters
	var HEX = "0123456789ABCDEF";

	var plaintext = txt;
	var encoded = "";
	for (var i = 0; i < plaintext.length; i++ ) {
		var ch = plaintext.charAt(i);
		if (ch == " ") {
			encoded += "+";				// x-www-urlencoded, rather than %20
		} else if (SAFECHARS.indexOf(ch) != -1) {
			encoded += ch;
		} else {
			var charCode = ch.charCodeAt(0);
			if (charCode > 255) {
				encoded += "+";
			} else {
				encoded += "%";
				encoded += HEX.charAt((charCode >> 4) & 0xF);
				encoded += HEX.charAt(charCode & 0xF);
			}
		}
	} // for
	return encoded;
};

//===========================
//pop frequency functions
//===========================

var rm_pop_frequency = 300;


var COOKIE_NAME = "ym_pop_freq_";

// whenever you want to show a pop ad, you first have to run the function 
// canShowPop(). If it returns true, you can show the pop. If false, don't show the 
// pop.
// We also need pop_frequency to be valid, so we need a check in rmtag.js like this:
//
// if (!window.pop_frequency) {
//	var pop_frequency = 60 ;
// }
//
// You should give an option in the tag generator to set
// pop frequency. Talk to me about this.
//
// You should add the following 4 functions to rmtag.js.
//


function canShowPop() {
	// Have to look for cookie with this site_id.
	if(cookieExists(rm_site_id) == false) {
		// This cookie doesn't exist,
		// so we CAN show the pop.
		ret = true;

		// We are going to show a pop,
		// so reset cookie.
		writePopFrequencyCookie(rm_site_id, rm_pop_frequency);
		
		return true;
	} else {
		return false;
	}
}

function cookieExists(rm_site_id) {
	var cookieName = COOKIE_NAME + rm_site_id;

	if(getCookie(cookieName) == null) {
		return false;
	} else {
		return true;
	}
}

function writePopFrequencyCookie(rm_site_id, rm_pop_frequency) {
	// Set cookie name.
	var cookieName = COOKIE_NAME + rm_site_id;

	// Set expiration date.
	var today= new Date();
	var expires = new Date();
	expires.setTime(today.getTime() + (1000 * rm_pop_frequency));

	var cookieText = cookieName + "=1;"
		+ "expires=" + expires.toGMTString() + ";";
	document.cookie = cookieText;
	return null;
}

// Returns null if cookie doesn't exist.
// Returns cookie value if it does exist.
function getCookie(Name) {
	var search = Name + "=";
	var CookieString = document.cookie;
	var result = null;
	
	if(CookieString.length > 0) {
		offset = CookieString.indexOf(search);
		if(offset != -1) {
			offset += search.length;
			end = CookieString.indexOf(";", offset);
			if(end == -1) {
			   end = CookieString.length;
			}
			result = unescape(CookieString.substring(offset, end));
	   }
	}
	return result;
}
